#!/usr/bin/env python
#
# by Kendall Weaver <kendalltweaver@gmail.com>
#
# Simple Mouse
#
# Graphical mouse settings tool written
# for the Linux Mint Fluxbox edition.

import sys
import gtk
import os

pad = str("synclient TouchPadOff=0")
paw = str("pointer = 1 2 3")
acc = int(2)
thr = int(2)

class Mouse(gtk.Window):

	def on_clicked(self, widget):
		gtk.main_quit()

	def on_destroy(self, widget):
		gtk.main_quit()

	def applicate(self, widget):
		os.system('touch $HOME/.linuxmint/tools/sms')
		os.system('echo "#!/bin/sh" > $HOME/.linuxmint/tools/sms')
		os.system('echo "#Autogenerated script - Do not edit" >> $HOME/.linuxmint/tools/sms')
		os.system('echo \"' + pad + '\" >> $HOME/.linuxmint/tools/sms')
		os.system('echo \'xmodmap -e \"' + paw + '\"\' >> $HOME/.linuxmint/tools/sms')
		os.system('echo \"xset m ' + str(acc) + ' ' + str(thr) + '\" >> $HOME/.linuxmint/tools/sms')
		os.system("sms1")

	def enable(self, widget):
		if widget.get_active():
			global pad
			pad = str("synclient TouchPadOff=0")
		else:
			global pad
			pad = str("synclient TouchPadOff=1")
		global pad
		print pad

	def southpaw(self, widget):
		if widget.get_active():
			global paw
			paw = str("pointer = 3 2 1")
		else:
			global paw
			paw = str("pointer = 1 2 3")
		print paw

	def acceleration(self, widget):
		widget.get_value()
		acc = int(widget.get_value())
		global acc
		print acc

	def threshold(self, widget):
		widget.get_value()
		thr = int(widget.get_value())
		global thr
		print thr

	def __init__(self):
		super(Mouse, self).__init__()

		self.set_title("Mouse Settings")
		self.set_size_request(400, 200)
		self.set_position(gtk.WIN_POS_CENTER)

		try:
			self.set_icon_from_file("/usr/lib/linuxmint/mint-fluxbox-tools/mouse.png")
			self.mouse = gtk.gdk.pixbuf_new_from_file("/usr/lib/linuxmint/mint-fluxbox-tools/mouse.png")
		except Exception, e:
			print e.message
			sys.exit(1)

		image1 = gtk.Image()
		image1.set_from_pixbuf(self.mouse)

		chk1 = gtk.CheckButton("Touchpad enabled")
		chk1.set_active(True)
		chk1.connect("clicked", self.enable)
		chk2 = gtk.CheckButton("Left Handed")
		chk2.set_active(False)
		chk2.connect("clicked", self.southpaw)

		lbl1 = gtk.Label("Acceleration")
		lbl2 = gtk.Label("Threshold")

		scl1 = gtk.HScale()
		scl1.set_range(0, 10)
		scl1.set_increments(1, 2)
		scl1.set_digits(0)
		scl1.set_value(2)
		scl1.set_size_request(150, 35)
		scl1.connect("value-changed", self.acceleration)
		scl2 = gtk.HScale()
		scl2.set_range(0, 10)
		scl2.set_increments(1, 2)
		scl2.set_digits(0)
		scl2.set_value(2)
		scl2.set_size_request(150, 35)
		scl2.connect("value-changed", self.threshold)

		btn1 = gtk.Button(stock=gtk.STOCK_APPLY)
		btn1.set_size_request(80, 30)
		btn1.connect("clicked", self.applicate)
		btn2 = gtk.Button(stock=gtk.STOCK_CLOSE)
		btn2.set_size_request(80, 30)
		btn2.connect("clicked", self.on_clicked)

		fixed = gtk.Fixed()

		fixed.put(chk1, 10, 140)
		fixed.put(chk2, 10, 165)
		fixed.put(lbl1, 125, 39)
		fixed.put(lbl2, 140, 94)
		fixed.put(scl1, 225, 20)
		fixed.put(scl2, 225, 75)
		fixed.put(btn1, 205, 147)
		fixed.put(btn2, 295, 147)
		fixed.put(image1, 10, 22)

		self.connect("destroy", self.on_destroy)

		self.add(fixed)
		self.show_all()

Mouse()
gtk.main()
